$(document).ready(function() {
	
	$(".menu-item").click(function(e) {
		
		e.preventDefault();
		
		window.location = $(this).attr("data-url");
		
	});
	
	function readURL(input) {

		if (input.files && input.files[0]) {
			var reader = new FileReader();
			
			$(".upload-in-progress").fadeIn();
		
			reader.onload = function(e) {
				
				var fd = new FormData();    
	           fd.append( 'photo', $('.profile_photo_input')[0].files[0]);
				
				// Upload on picked
				$.ajax({
					url: "ajax/upload_profile_picture.php", // Url to which the request is send
					type: "POST",             // Type of request to be send, called as method
					data: fd, // Data sent to server, a set of key/value pairs (i.e. form fields and values)
					contentType: false,       // The content type used when sending data to the server.
					cache: false,             // To unable request pages to be cached
					processData:false,        // To send DOMDocument or non processed data file it is set to false
					dataType: "json",
					success: function(data)   // A function to be called if request succeeds
					{
						$(".upload-in-progress").html("OK!");
						
						setTimeout(function() {
							$(".upload-in-progress").hide();
							$(".upload-in-progress").html('<i class="fas fa-circle-notch fa-spin"></i><br>Upload in progress...');
							$(".delete_profile_picture").show();
	
						}, 1500);
													
						
						if(data.error && data.error != "") {
							alert(data.error);
						} else {
							$('.profile_picture_container img').attr('src', e.target.result);
						}
						}
				});
			}
			
			reader.readAsDataURL(input.files[0]);
		}
	}
	
	$(".delete_profile_picture").click(function(e) {
		
		e.preventDefault();
		e.stopPropagation();
		
		var that = $(this);
		
		$.ajax({
	        url: "ajax/delete_profile_picture.php",
	        type: 'POST',
	        dataType: "json",
	        success: function (data) {
		        
				that.hide();
				$('.profile_picture_container img').attr('src', "img/default_avatar.jpg");
		
			}
		});
		
	});
	
	$(".profile_photo_input").change(function() {
		readURL(this);
	});
	
	$(".profile_picture_container a").click(function(e) {
		
		e.preventDefault();
		
		$(".profile_photo_input").click();
		
	});
	
	// Main button clicked to create the event & occasion
	$("form#profile-form").submit(function(e) {
		
		e.preventDefault();    
		
	    var formData = new FormData(this);
	    var btn_html = $("form#profile-form .edit-usr-btn").html();
	    
	    $("form#profile-form .edit-usr-btn").prop("disabled", true);
	    $("form#profile-form .edit-usr-btn").html("<i class='fas fa-circle-notch fa-spin'></i>");
	    
	    $(".errors-step-2").hide();
	
	    $.ajax({
	        url: "ajax/edit-profile.php",
	        type: 'POST',
	        data: formData,
	        dataType: "json",
	        success: function (data) {
		        
		        $("form#profile-form .edit-usr-btn").html(btn_html);
		        				        
	            if(data.has_error == true) {
		            
		            $("form#profile-form .edit-usr-btn").prop("disabled", false);
		
		            // Input text errors on step 1            
		            if(data.error > 990) {
			            
			            $(".error-profile").html(data.error_txt).fadeIn();
			            
		            } else {
			            
			            alert("Unexpected error...");
			            
		            }
		            
	            } else {
		            
		            $("form#profile-form .edit-usr-btn").removeClass("btn-primary").addClass("btn-success").html("<i class='fas fa-check'></i> Profile Saved");
		            
					setTimeout(function() {
						$("form#profile-form .edit-usr-btn").prop("disabled", false);
				   		$("form#profile-form .edit-usr-btn").removeClass("btn-success").addClass("btn-primary").html(btn_html);
					}, 3000);
		            
	            }
	            
	        },
	        cache: false,
	        contentType: false,
	        processData: false
	    });
		
	});
	
	$(".btn-delete-account").click(function(e) {
		
		e.preventDefault();
		
		var confirm = window.confirm("Are you sure you want to delete your account? All your quiz and informations will be permanently removed");
		
		if(confirm) {
			window.location = $(this).attr("href");
		}
		
	});
	
});

